from microbit import *
import Obloq
import neopixel

np = neopixel.NeoPixel(pin13, 7)

SERVER = "192.168.9.49"         #修改为服务器地址
PORT = "1883"                   #端口号：1883
SSID = "DFRobot-guest"          #修改为wifi名称，不要使用中文
PASSWORD = "dfrobot@2017"       #修改为wifi密码
IOT_ID = "siot"                 #iot_id账号
IOT_PWD = "dfrobot"             #iot_pwd密码
IOT_TOPIC1 = "Light/1"          #修改topic名称，命名方式：项目 ID/设备名，不可缺少符号/

uart.init(baudrate=9600, bits=8, parity=None, stop=1, tx=pin2, rx=pin1)

def ConnectWifi():    
    while Obloq.connectWifi(SSID,PASSWORD,10000) != True:
        display.show(".")
    display.scroll(Obloq.ifconfig()) 
    
#设置MQTT的回调函数 
def event(e,param):
    if e == IOT_TOPIC1:#收到了订阅的topic的信息
        display.scroll(param)
        if param == "ON":
            for pixel_id in range(0, len(np)):
                red = 0
                green = 0
                blue = 100
                np[pixel_id] = (red, green, blue)
                np.show()
        if param == "OFF":  
            np.clear()
        
    if e == "MqttConneted":#MQTT连接成功
        display.scroll("OK")
    if e == "SubOk":#订阅成功        
        display.scroll("OK")        
ConnectWifi()

#初始化MQTT的配置
Obloq.mqttConfig(event,SERVER,PORT)

#连接MQTT
Obloq.connectMqtt(IOT_ID,IOT_PWD)
sleep(300)
Obloq.subscribe(IOT_TOPIC1)#订阅Topoic1
sleep(300)
while True:
    pass
