from mpython import * 
import time 
from machine import Pin 
import onewire, ds18x20 

ow = onewire.OneWire(Pin(Pin.P13)) 
# create the onewire object 
ds = ds18x20.DS18X20(ow) 

# scan for devices on the bus 
roms = ds.scan() 
print('found devices:', roms) 

while True: 
    print('temperatures:', end=' ') 
    ds.convert_temp() 
    time.sleep_ms(750) 
    for rom in roms: 
        print(ds.read_temp(rom), end=' ') 
    print()