from mpython import * # 导入mpython模块  
import onewire, ds18x20 

p1=MPythonPin(1,PinMode.ANALOG) 
# 实例化MPythonPin,将P1设置为"PinMode.ANALOG"模式 
p0=MPythonPin(0,PinMode.OUT) 
# 实例化MPythonPin,将P0设置为"PinMode.OUT"模式 

ow = onewire.OneWire(Pin(Pin.P13)) 
# create the onewire object 
ds = ds18x20.DS18X20(ow) 

# scan for devices on the bus 
roms = ds.scan() 
print('found devices:', roms) 

while True: 
    value=p1.read_analog() # 读取P1引脚模拟量 
    oled.DispChar("土壤湿度:%d" %value,30,14) 
    oled.show() 
    oled.fill(0) 
    if value <= 210: #当土壤湿度低于210的时候进行浇水 
        p0.write_digital(1) # P0写高电平 
        sleep(1) 
    if value > 210: 
        p0.write_digital(0) # P0写低电平
    print('temperatures:', end=' ') 
    ds.convert_temp() 
    time.sleep_ms(750) 
    for rom in roms: 
        print(ds.read_temp(rom), end=' ') 
    print()