from umqtt.simple import MQTTClient    
from mpython import *   
from machine import Timer  
import neopixel #导入灯带模块
np = neopixel.NeoPixel(Pin(Pin.P8), n=7,bpp=3,timing=1) # 初始化灯带

SERVER = "192.168.43.194" # MQTT服务器IP，即运行SIoT的电脑IP
username='siot'           # SIoT默认用户名（user）为：siot
password='dfrobot'        # 默认密码（pwd）为：dfrobot
CLIENT_ID = ""            # 你的Easy IoT上的Client ID 

TOPIC='df/sdf'            # 自定义topic，命名方式：项目ID/设备名，不可缺少符号/

mywifi=wifi()             # 实例化wifi类
mywifi.connectWiFi("Jiao P30","syj12345678")   # 连接wifi,替换成你的wifi

try:
    def sub_cb(topic, msg):             # 当接收到订阅消息时的回调函数
        print((topic, msg))             # 打印接收的主题消息
      
        if topic == TOPIC.encode():     # 如果topic为我们设备的topic时,由于收到为字节类型。这里需要将 TOPIC 转换为字节类型。
            if msg == b"on":                # 如果消息为“on”,亮灯  
                np.fill((0,100,0))
                np.write()

            elif msg == b"off":         # 如果消息为“off”,灭灯  
                np.fill((0,0,0))
                np.write()

    c = MQTTClient(CLIENT_ID, SERVER,1883,username,password,keepalive=30)   # MQTTClient类实例,并设置连接保持时间间隔为30秒
    c.connect()                             # mqtt连接
    c.set_callback(sub_cb)                  # 设置回调函数
    c.subscribe(TOPIC)                      # 订阅主题
    print("Connected to %s" % SERVER)
    c.publish(TOPIC,"hello")

    tim1 = Timer(1)                          # 创建定时器1
    tim1.init(period=20000, mode=Timer.PERIODIC,callback=lambda n:c.ping())     # 20秒间隔发送Ping,保持连接

    while True:         
        c.wait_msg()                    # 循环等待消息
        
finally:
    c.disconnect()                     # 异常时,断开mqtt连接