# 功能：读取RFID卡ID信息
# 实验：
#             将RFID读卡器的TXD接在P15    RXD接在P16，运行此程序
#             将RFID卡放在读卡器上, 读到NFC卡, 蜂鸣器将响一下
#             OLED屏幕上显示对应的信息
'''
注意： 要先烧录rfid_pn532.py文件
'''

from machine import UART
from mpython import *
import time
import music
from rfid_pn532 import RFID_PN532

u = UART(1, baudrate=115200, rx=Pin.P15, tx=Pin.P16, timeout=10)

pn = RFID_PN532(u)

oled.fill(0)
oled.DispChar("正在连接读卡器...",0,0)
oled.show()

pn.wakeup()
oled.DispChar("连接成功", 32,32)
oled.show()
oled.fill(0)

while True:
    detected,id = pn.read_tag()
    if detected:
        oled.DispChar('探测到NFC卡',0,16)
        music.play(music.BA_DING)
        oled.DispChar(" id=%2x%2x%2x%2x"%(id[0],id[1],id[2],id[3]),32,32)
    else:
        oled.DispChar('未检测到卡',0,16)
    oled.show()
    oled.fill(0)
    time.sleep(1)