from machine import I2C,Pin

class CCS811:

    CCS811_IIC_ADDR = 0x5A

    def __init__(self):

        self.i2c = I2C(scl=Pin(22), sda=Pin(23), freq=100000)  

        buf = bytearray(1)

        buf[0] = 0xF4

        self.i2c.writeto(self.CCS811_IIC_ADDR, buf)



        self._set_measurement_mode(0, 0, 4)

        self._set_in_temp_hum(25, 50)

        self.set_meas_cycle(4)



    def _read_reg(self, reg, size):

        buf = bytearray(1)

        buf[0] = reg

        self.i2c.writeto(self.CCS811_IIC_ADDR,buf)

        return self.i2c.readfrom(self.CCS811_IIC_ADDR, size)



    def _set_measurement_mode(self, thresh, interrupt, mode):

        measurement = [0]

        measurement[0] = (thresh << 2) | (interrupt << 3) | (mode << 4)

        buf = bytearray(2)

        buf[0] = 0x01

        buf[1] = measurement[0]

        self.i2c.writeto(self.CCS811_IIC_ADDR, buf)



    def _set_in_temp_hum(self, temperature, humidity):

        envData = [0]*4

        if(temperature > 0):

            _temp = int(temperature+0.5)

        else:

            _temp = int(temperature-0.5)



        _rh = int(humidity+0.5)

        envData[0] = _rh << 1

        envData[1] = 0

        envData[2] = _temp << 1

        envData[3] = 0



        buf = bytearray(5)

        buf[0] = 0x05

        buf[1] = envData[0]

        buf[2] = envData[1]

        buf[3] = envData[2]

        buf[4] = envData[3]

        self.i2c.writeto(self.CCS811_IIC_ADDR, buf)



    def check_data_ready(self):

        buf = self._read_reg(0x00, 1)

        if(not((buf[0] >> 3) & 0x01)):

            return False

        else:

            return True



    def set_meas_cycle(self, ecycle):

        measurement = [0]

        measurement[0] = ecycle << 4

        buf = bytearray(2)

        buf[0] = 0x01

        buf[1] = measurement[0]

        self.i2c.writeto(self.CCS811_IIC_ADDR, buf)



    def read_baseline(self):

        buf = bytearray(1)

        buf[0] = 0x11

        self.i2c.writeto(self.CCS811_IIC_ADDR, buf)

        rbuf = self.i2c.readfrom(self.CCS811_IIC_ADDR, 2)

        baseline = rbuf[0] << 8 | rbuf[1]

        return hex(baseline)



    def CO2_PPM(self):

        buf = self._read_reg(0x02, 8)

        self.eCO2 = buf[0] << 8 | buf[1]

        return self.eCO2



    def TVOC_PPB(self):

        buf = self._read_reg(0x02, 8)

        self.eTVOC = buf[2] << 8 | buf[3]

        return self.eTVOC



    def write_base_line(self, baseline):

        data = [0]*2

        data[0] = baseline >> 8

        data[1] = baseline

        

        buf = bytearray(3)

        buf[0] = 0x11

        buf[1] = data[0]

        buf[2] = data[1]

        self.i2c.writeto(self.CCS811_IIC_ADDR, buf)

