import time

class RFID_PN532:
  def __init__(self,uart,interval=200):
    self.uart = uart
    self.interval = interval
    self.ack = bytearray(25)
    self.id = bytearray(4)
  def send_and_response(self,cmd):
    self.uart.write(cmd)
    time.sleep_ms(self.interval)
    resp = self.uart.read()
    return resp

  def wakeup(self):
    cmd= b'\x55\x55\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xff\x03\xfd\xd4\x14\x01\x17\x00'
    respect = b'\x00\x00\xff\x00\xff\x00\x00\x00\xff\x02\xfe\xd5\x15\x16\x00'
    while True:
      r = self.send_and_response(cmd)
      if r == respect:
        break
      time.sleep_ms(100)

  def read_tag(self):
    detected = False
    new_card = False
    cmd = b'\x00\x00\xFF\x04\xFC\xD4\x4A\x01\x00\xE1\x00'
    time.sleep_ms(self.interval)
    r = self.send_and_response(cmd)
    if(len(r) == 6):
      self.id=b'\x00\x00\x00\x00'
    elif(len(r) == 25):
      detected = True
      if(self.is_new_card(r)):
        self.id = r[19:23]
        new_card = True
    return detected,self.id
  
  def is_new_card(self, resp):
    std_ack = b'\x00\x00\xFF\x00\xFF\x00\x00\x00\xFF\x0C\xF4\xD5\x4B\x01\x01\x00\x04\x08\x04'
    if(self.id == resp[19:23]):
      return False
    if(std_ack != resp[0:19]):
      return False
    return True
 
