# Ultralytics COCO8 Dataset

## Introduction

[Ultralytics](https://ultralytics.com) COCO8 is a small, but versatile object detection dataset composed of the first 8
images of the COCO train 2017 set, 4 for training and 4 for validation. This dataset is ideal for testing and debugging
object detection models, or for experimenting with new detection approaches. With 8 images, it is small enough to be
easily manageable, yet diverse enough to test training pipelines for errors and act as a sanity check before training
larger datasets.

This dataset is intended for use with Ultralytics [HUB](https://hub.ultralytics.com)
and [YOLOv8](https://github.com/ultralytics/ultralytics).

## Sample Images and Annotations

Here are some examples of images from the dataset, along with their corresponding annotations in a training mosaic:

<img src="https://user-images.githubusercontent.com/26833433/236818348-e6260a3d-0454-436b-83a9-de366ba07235.jpg" alt="Dataset sample image" width="800">

## Resources

We hope that the variety of resources provided here will help you get the most out of HUB and maximize your experience
with HUB and COCO8.

- Browse the [Docs](https://docs.ultralytics.com/) for details on usage and implementation.
- Raise an issue on [GitHub](https://github.com/ultralytics/hub/issues/new/choose) for support and troubleshooting.
- Join our [Discord](https://discord.gg/n6cFeSPZdD) community for questions and discussions with fellow users and
  developers.
- Learn more about Ultralytics and our work at our [Community](https://community.ultralytics.com) page.
- Explore the Ultralytics YOLOv8 [GitHub](https://github.com/ultralytics/ultralytics) repository for additional tools
  and resources.

To request an Enterprise License, please complete the form at [Ultralytics Licensing](https://ultralytics.com/license).
