import lcd_bus
from micropython import const
import machine

# 显示设置
_WIDTH = const(240)  # 显示屏宽度
_HEIGHT = const(320)  # 显示屏高度
_BL = const(21)  # 背光引脚
_RST = const(38)  # 复位引脚
_DC = const(3)  # 数据/命令控制引脚

_MOSI = const(15)  # SPI MOSI引脚
_MISO = const(16)  # SPI MISO引脚
_SCK = const(17)  # SPI SCK引脚
_HOST = const(1)  # SPI2

_LCD_CS = const(18)  # LCD芯片选择引脚
_LCD_FREQ = const(40000000)  # LCD SPI通信频率

_TOUCH_CS = const(12)  # 触摸芯片选择引脚
_TOUCH_FREQ = const(10000000)  # 触摸SPI通信频率

_BUFFER_SIZE = const(30720)

# 创建SPI总线对象
spi_bus = machine.SPI.Bus(
    host=_HOST,     # 显式转换为整数
    mosi=_MOSI,
    miso=_MISO,
    sck=_SCK
)

# 创建显示屏的SPI通信对象
display_bus = lcd_bus.SPIBus(
    spi_bus=spi_bus,
    freq=_LCD_FREQ,
    dc=_DC,
    cs=_LCD_CS
)

fb1 = display_bus.allocate_framebuffer(_BUFFER_SIZE, lcd_bus.MEMORY_INTERNAL | lcd_bus.MEMORY_DMA)
fb2 = display_bus.allocate_framebuffer(_BUFFER_SIZE, lcd_bus.MEMORY_INTERNAL | lcd_bus.MEMORY_DMA)

import ili9341  # NOQA
import lvgl as lv  # NOQA

# 创建显示屏对象
display = ili9341.ILI9341(
    data_bus=display_bus,
    frame_buffer1=fb1,
    frame_buffer2=fb2,
    display_width=_WIDTH,
    display_height=_HEIGHT,
    reset_pin=_RST,
    reset_state=ili9341.STATE_LOW,
    backlight_pin=_BL,
    color_space=lv.COLOR_FORMAT.RGB565,
    color_byte_order=ili9341.BYTE_ORDER_BGR,
    rgb565_byte_swap=True,
)

# 初始化显示屏
display.init(2)
# 打开屏幕背光
display.set_backlight(1)

import task_handler
import xpt2046 #pointer_framework

# 创建触摸屏设备对象
touch_dev = machine.SPI.Device(
    spi_bus=spi_bus,
    freq=_TOUCH_FREQ,
    cs=_TOUCH_CS
)

indev = xpt2046.XPT2046(touch_dev)  # 初始化触摸设备

#if not indev.is_calibrated:  # 如果触摸设备未校准
#indev.calibrate()  # 进行校准
#indev._cal.mirrorX = False
#indev._cal.mirrorY = True
#indev._cal.save()

# 启用输入优先级
indev.enable_input_priority()

# 创建一个任务处理器实例
th = task_handler.TaskHandler()
