import lcd_bus
from micropython import const
import machine
import lcd_utils

# 创建SPI总线对象
spi_bus = machine.SPI.Bus(
    host=1,
    mosi=6,
    miso=5,
    sck=4, 
)

# 创建显示屏的SPI通信对象
display_bus = lcd_bus.SPIBus(
    spi_bus=spi_bus,
    freq=40000000,
    dc=1,
    cs=7,
)

import ili9488
import lvgl as lv
import task_handler

# 创建显示屏对象
display = ili9488.ILI9488(
    data_bus=display_bus,
    display_width=320,
    display_height=480,
    backlight_pin=10,
    reset_pin=2,
    reset_state=ili9488.STATE_LOW,
    color_space=lv.COLOR_FORMAT.RGB888,
    color_byte_order=ili9488.BYTE_ORDER_RGB,
    rgb565_byte_swap=True,
)
# 初始化显示屏
display.init()
# 打开屏幕背光
display.set_backlight(1)
# 旋转显示
display.set_rotation(lv.DISPLAY_ROTATION._90)

import i2c
import task_handler
import gt911

# 定义触摸屏的I2C通信参数
i2c_bus = i2c.I2C.Bus(host=0, scl=9, sda=8, freq=400000, use_locks=False)
touch_dev = i2c.I2C.Device(bus=i2c_bus, dev_id=0x5D, reg_bits=gt911.BITS)

# 创建触摸屏设备对象
indev = gt911.GT911(touch_dev)

# 如果未校准，则进行校准
#indev.calibrate()
#indev._cal.mirrorX = False
#indev._cal.mirrorY = True
#indev._cal.save()

# 启用输入优先级
indev.enable_input_priority()
th = task_handler.TaskHandler()


