import lcd_bus
from micropython import const
import machine
import lcd_utils

# 创建SPI总线对象
spi_bus = machine.SPI.Bus(
    host=1,
    mosi=15,
    miso=16,
    sck=17, 
)

# 创建显示屏的SPI通信对象
display_bus = lcd_bus.SPIBus(
    spi_bus=spi_bus,
    freq=40000000,
    dc=3,
    cs=18,
)

import st7789 
import lvgl as lv
import task_handler

# 创建显示屏对象
display = st7789.ST7789(
    data_bus=display_bus,
    display_width=240,
    display_height=320,
    backlight_pin=21,
    reset_pin=38,
    reset_state=st7789.STATE_LOW,
    color_space=lv.COLOR_FORMAT.RGB565,
    color_byte_order=st7789.BYTE_ORDER_BGR,
    rgb565_byte_swap=True,
)
# 初始化显示屏
display.init()
# 打开屏幕背光
display.set_backlight(1)
# 旋转显示
display.set_rotation(lv.DISPLAY_ROTATION._90)

th = task_handler.TaskHandler()

