enum APPEND {
    //% block="追加模式"
    true,
    //% block="覆盖模式"
    false
}

//% color="#5b3fe8" iconWidth=50 iconHeight=40
namespace SDCard{
    //% block="SD卡初始化成功" blockType="boolean" 
    export function isSDCardInit(parameter: any, block: any) {
	    Generator.addInclude("includeSDCard", "#include <SDCard.h>");
		Generator.addObject(`SDCard`,`SDCard`,`sdCard`;); 
        Generator.addCode(`sdCard.init()`);   
    }	
  
	
    //% block="存储[MESSAGE]到TF卡文件[FILEPATH][APPEND]" blockType="command"
	//% MESSAGE.shadow="string" MESSAGE.defl="K10"
	//% FILEPATH.shadow="string" FILEPATH.defl="/test.txt"
	//% APPEND.shadow="dropdown" APPEND.options="APPEND"
    export function writeFile(parameter: any, block: any) {
        let message = parameter.MESSAGE.code; 
        let filePath = parameter.FILEPATH.code;
        let append = parameter.APPEND.code; 		
        Generator.addCode(`sdCard.writeFile(${filePath}, ${message}, ${append});`);   
    }

	
    //% block="读取TF卡文件[FILEPATH]" blockType="reporter" 
    //% FILEPATH.shadow="string" FILEPATH.defl="/test.txt"
    export function getWeatherDataValue(parameter: any, block: any) { 
        let filePath = parameter.FILEPATH.code;       
        Generator.addCode(`sdCard.readFile(${filePath})`);   
    }
	
	
    //% block="删除TF卡文件[FILEPATH]" blockType="command"
	//% FILEPATH.shadow="string" FILEPATH.defl="/test.txt"
    export function deleteFile(parameter: any, block: any) {
        let filePath = parameter.FILEPATH.code; 		
        Generator.addCode(`sdCard.deleteFile(${filePath};`);   
    }
	
	
	//% block="检查文件[FILEPATH]是否存在" blockType="boolean" 
	//% FILEPATH.shadow="string" FILEPATH.defl="/test.txt"
	export function isFileExists(parameter: any, block: any) {
        let filePath = parameter.FILEPATH.code; 	
        Generator.addCode(`fileExists(${filePath})`);   
    }	
}