#include "SDCard.h"

// 构造函数，存储引脚信息
SDCard::SDCard(int cs, int mosi, int miso, int sck) : chipSelect(cs), mosiPin(mosi), misoPin(miso), sckPin(sck) {}

// 初始化 SD 卡
bool SDCard::init() {
    Serial.begin(115200);
    while (!Serial) {
        ; // 等待串口连接
    }

    // 自定义 SPI 引脚配置
    SPI.begin(sckPin, misoPin, mosiPin, chipSelect);

    if (!SD.begin(chipSelect)) {
        Serial.println("SD 卡初始化失败");
        return false;
    }
    Serial.println("SD 卡初始化成功");
    return true;
}

// 写入文件，如果文件已存在，则根据模式追加或覆盖内容并换行
bool SDCard::writeFile(const String& path, const String& message, bool append) {
    Serial.printf("正在写入文件: %s\n", path.c_str());

    // 如果目录不存在，创建目录
    String dir = path.substring(0, path.lastIndexOf('/'));
    if (!SD.exists(dir.c_str())) {
        if (!SD.mkdir(dir.c_str())) {
            Serial.println("创建目录失败");
            return false;
        }
    }

    const char* openMode = append? FILE_APPEND : FILE_WRITE;
    File file = SD.open(path.c_str(), openMode);
    if (!file) {
        Serial.println("无法打开文件进行写入");
        return false;
    }
    if (file.print(message)) {
        Serial.println("文件写入成功");
        if (file.println()) { 
            Serial.println("换行符添加成功");
        } else {
            Serial.println("换行符添加失败");
        }
        file.close();
        return true;
    } else {
        Serial.println("文件写入失败");
        file.close();
        return false;
    }
}

// 读取文件
String SDCard::readFile(const String& path) {
    Serial.printf("正在读取文件: %s\n", path.c_str());

    File file = SD.open(path.c_str());
    if (!file) {
        Serial.println("无法打开文件进行读取");
        return "";
    }

    String fileContent;
    while (file.available()) {
        fileContent += (char)file.read();
    }
    file.close();
    
    Serial.println("文件内容:");
    Serial.println(fileContent);
    
    return fileContent;
}

// 检查文件是否存在
bool SDCard::fileExists(const String& path) {
    return SD.exists(path.c_str());
}

// 删除文件
bool SDCard::deleteFile(const String& path) {
    if (SD.remove(path.c_str())) {
        Serial.printf("文件已删除: %s\n", path.c_str());
        return true;
    } else {
        Serial.printf("删除文件失败: %s\n", path.c_str());
        return false;
    }
}