#ifndef SD_CARD_H
#define SD_CARD_H

#include <FS.h>
#include <SD.h>
#include <SPI.h>
#include <String.h>

class SDCard {
  private:
    const int chipSelect;
    const int mosiPin;
    const int misoPin;
    const int sckPin;

  public:
    // 构造函数，允许用户自定义引脚
    SDCard(int cs = 40, int mosi = 42, int miso = 41, int sck = 44);
    // 初始化 SD 卡
    bool init();
    // 写入文件，如果文件已存在，则根据模式追加或覆盖内容并换行
    bool writeFile(const String& path, const String& message, bool append = true);
    // 读取文件
    String readFile(const String& path);
    // 检查文件是否存在
    bool fileExists(const String& path);
    // 删除文件
    bool deleteFile(const String& path);
};

#endif // SD_CARD_H