#include <Arduino.h>
#include "SDCard.h"

// 创建 SDCard 对象，使用默认引脚
SDCard sdCard;

void setup() {
    Serial.begin(115200);
    while (!Serial) {
        ; // 等待串口连接
    }

    Serial.println("SD卡测试程序开始");

    // 初始化 SD 卡
    if (!sdCard.init()) {
        Serial.println("SD卡初始化失败，请检查连接");
        return;
    }

    // 写入文件，使用追加模式
    const String filePath = "/test/example.txt";
    const String message = "这是一个追加的测试消息";
    if (sdCard.writeFile(filePath, message, true)) {
        Serial.println("文件追加成功");
    } else {
        Serial.println("文件追加失败");
    }

    // 写入文件，使用覆盖模式
    const String overwriteMessage = "这是一个覆盖的测试消息";
    if (sdCard.writeFile(filePath, overwriteMessage, false)) {
        Serial.println("文件覆盖成功");
    } else {
        Serial.println("文件覆盖失败");
    }

    // 检查文件是否存在
    if (sdCard.fileExists(filePath)) {
        Serial.println("文件存在");
    } else {
        Serial.println("文件不存在");
    }

    // 读取文件
    String fileContent = sdCard.readFile(filePath);
    if (fileContent!= "") {
        Serial.println("文件内容：");
        Serial.println(fileContent);
    } else {
        Serial.println("文件读取失败或文件为空");
    }

    // 删除文件
    if (sdCard.deleteFile(filePath)) {
        Serial.println("文件删除成功");
    } else {
        Serial.println("文件删除失败");
    }

    // 再次检查文件是否存在
    if (!sdCard.fileExists(filePath)) {
        Serial.println("文件已成功删除");
    } else {
        Serial.println("文件删除失败，文件仍然存在");
    }

    Serial.println("SD卡测试程序结束");
}

void loop() {
    // 主循环为空，因为我们只需要运行一次测试
}